! Madelbrot lambda map
! The set of complewx number c such that
! the repetition of f(z)=c(1-z) is bounded.
! This program repeats 250 times for each points on the screen.
! Overflow exception gives a decision for non-bouned.
OPTION ARITHMETIC COMPLEX
LET left = -2                  ! left                 
LET right = 4                   ! right               
LET h = (right - left)              ! height
SET WINDOW left, right,-h/2,h/2    
ASK PIXEL SIZE(left,-h/2;right,h/2) px,py
LET px=px-1
LET py=py-1
DRAW grid
SET POINT STYLE 1
FOR u= left TO right step (right-left)/px                               
   FOR v = 0 to h/2 step h/py
      LET Lambda=COMPLEX(u,v)                            
      LET z=0.5             ! initial value                           
      WHEN EXCEPTION IN                        
         FOR n = 1 TO 250                        
            LET z=lambda*z*(1-z)   
         NEXT n                                  
         PLOT POINTS: u,v
         PLOT POINTS: u,-v   
      USE
      END WHEN                           
   NEXT v                                      
NEXT u                                        
END                                             


