! Lorenz attractor
OPTION ARITHMETIC NATIVE
OPTION ANGLE DEGREES
LET theta0=45      ! Rotation angle about the z-axis
LET t=-60          ! Initial Rotation angle about the x-axis
LET s=0            ! Initial Rotation angle about the y-axis
REM Show Lorenz attractor
REM rotating about the z-axis by theta0 degges,
REM rotating about the x-axis by t degrees,
REM rotating about the y-axis by s degrees.
REM When dragging the figure transversely, the firure rotates about the y-axis,
REM and when dragging longitudinallyCit rotates about x-axis.
DIM m(4,4),mm(4,4)
MAT m=ROTATE(theta0)
SET POINT STYLE 1
SET WINDOW -90, 90, -90, 90
DO 
   DIM rotx(4,4)   
   MAT rotx=IDN
   LET rotx(2,2)=COS(t)
   LET rotx(2,3)=SIN(t)
   LET rotx(3,2)=-SIN(t)
   LET rotx(3,3)=COS(t)
   DIM roty(4,4)     
   MAT roty=IDN
   LET roty(1,1)=COS(s)
   LET roty(1,3)=-SIN(s)
   LET roty(3,1)=SIN(s)
   LET roty(3,3)=COS(s)
   MAT m=m *  rotx * roty 
   SET DRAW mode hidden
   CLEAR
   PLOT TEXT, AT -90,-90: "Drag the object to rotate. Right-click to end."
    
   REM Lorenz
   LET s=11
   LET b=8/4
   LET r=88
   LET x=15
   LET y=25
   LET z=75 
   LET dt=1/256
   FOR t=0 TO 75 STEP dt
      LET xx=x+(-s*x+s*y)*dt
      LET yy=y+(r*x-y-x*z)*dt
      LET zz=z+(-b*z+x*y)*dt
      LET x=xx
      LET y=yy
      LET z=zz
      CALL PLOT(x,y,z)
   NEXT t
    
   REM x
   CALL PenUp
   CALL PLOT(0,0,0)
   CALL PLOT(50,0,0)
   CALL PLOTLABEL(50,0,0,"x") 
   REM y
   CALL PenUp
   CALL PLOT(0,0,0)
   CALL PLOT(0,50,0)
   CALL PLOTLABEL(0,50,0,"y") 
   REM z
   CALL PenUp
   CALL PLOT(0,0,0)
   CALL PLOT(0,0,150)
   CALL PLOTLABEL(0,0,150,"z") 
    
   SET DRAW mode explicit
   MOUSE POLL x,y,l,r
   IF r<>0 THEN EXIT DO
   LET t=0
   LET s=0
   IF l<>0 THEN    
      LET t=-2*(y-y0)
      LET s= 2*(x-x0)
   END IF 
   LET x0=x
   LET y0=y
LOOP

DIM POINT(4)
SUB PLOT(x,y,z)
   LET POINT(1)=x
   LET POINT(2)=y
   LET POINT(3)=z-70
   MAT POINT=POINT*m
   PLOT LINES:POINT(1),POINT(2);
END SUB

SUB PenUp
   PLOT LINES
END SUB

SUB PLOTLABEL(x,y,z,s$)
   LET POINT(1)=x
   LET POINT(2)=y
   LET POINT(3)=z-70
   MAT POINT=POINT*m
   PLOT LABEL ,AT POINT(1),POINT(2):s$
END SUB

END 
!
