! Sierpinski gasket
! Let f1, f2, f3 be the scalings of the centers at three vertices of a triangle ABC by 1/2.
! The self-similar set such as f1(D)Uf2(D)Uf3(D)=D. 
! Asumming  A(0,0), B(2,0), C(1,SQR(3)) .
PICTURE gasket(n)
   IF n=0 THEN 
      PLOT AREA: 0,0; 2,0; 1,SQR(3)
   ELSE
      DRAW gasket(n-1) WITH SCALE(1/2) 
      DRAW gasket(n-1) WITH SHIFT(-2,0)*SCALE(1/2)*SHIFT(2,0)
      DRAW gasket(n-1) WITH SHIFT(-1,-SQR(3))*SCALE(1/2)*SHIFT(1,SQR(3))
   END IF
END PICTURE
SET WINDOW 0,2,0,2
FOR n=0 TO 10
   CLEAR
   DRAW gasket(n)
   WAIT DELAY 1
NEXT n
END