REM A transformation which maps whole the plane onto the unit circale.
SET COLOR MODE "NATIVE"   
GLOAD "zenkouji.JPG" 
ASK PIXEL SIZE (0,0; 1,1) a,b   
DIM p(a,b)                    
ASK PIXEL ARRAY (0,1) p         
SET BITMAP SIZE 1001,1001       
CLEAR                        
SET POINT STYLE 1
SET WINDOW -1, 1, -1, 1         
FOR i=PIXELx(-1) TO PIXELx(1)
   FOR j=PIXELy(-1) TO PIXELy(1)
      LET x=PROBLEMx(i)               
      LET y=PROBLEMy(j)              
      LET r=SQR(x^2+y^2)
      IF r<1 THEN
         LET x0=x/SQR(1-r^2)                ! x-coordinate on the original picture
         LET y0=y/SQR(1-r^2)                ! y-coordinate on the original picture
         LET u=MOD(ROUND(x0*2*a), 2*a)-a      
         LET v=MOD(ROUND(y0*2*b), 2*b)-b      
         IF u<0 THEN LET u=-u ELSE LET u=u+1  
         IF v<0 THEN LET v=-v ELSE LET v=v+1  
         SET POINT COLOR p(u,v)
         PLOT POINTS: x,y
      END if
   NEXT j
NEXT i
END


