unit dataseqv2;

{$mode delphi}

interface

uses
  Classes, SysUtils;
type
TDataSeqV2 = class
  public
     DataList:TStringList;
     LabelNumbers:TStringList;
   constructor create;
   destructor destroy;override;
   procedure setLabelNumber(labelNumber:integer);
   {For Code Gen.}
   function LiteralCode:AnsiString;
end;

implementation
uses base,objlist,sconsts;

constructor TDataSeqV2.create;
begin
    inherited create;
    DataList:=TstringList.create;
    LabelNumbers:=TStringList.create;
    //DataPointer:=0;
end;

destructor TDataSeqV2.destroy;
begin
    with LabelNumbers do begin clear;free end;
    with DataList do begin clear;Free end;
    inherited destroy;
end;

procedure TDataSeqV2.setLabelNumber(labelNumber:integer);
begin
    if LabelNumber>0 then
       begin
          while LabelNumbers.count<DataList.count do LabelNumbers.add('');
          LabelNumbers.add(Strint(LabelNumber));
       end;
end;



function TDataSeqV2.LiteralCode:AnsiString;
var
   i:integer;
   s,t:Ansistring;
   c:integer;
begin
   c:=DataList.Count;
   s:=''; t:='';
   for i:=0 to c-1 do
     begin
       if i>0 then begin s:=s+',';t:=t+',' end;
       s:=s+QuotedStr(DataList.Strings[i]);
       if (i<labelNumbers.count) and
          (LabelNumbers.Strings[i]<>'') then
             t:=t+LabelNumbers.Strings[i]
       else
          t:=t+'0';
     end;
   result:='const'+EOL
          +' DataList:Array[0..'+inttostr(c-1)+'] of string = (' +s+');'+EOL
          +' DataLabels:Array[0..'+inttostr(c-1)+'] of integer = (' +t+');'+EOL
end;

initialization

finalization


end.

