unit graphlibc;

{$mode objfpc}{$H+}

(***************************************)
(* Copyright (C) 2013, SHIRAISHI Kazuo *)
(***************************************)

{********}
interface
{********}
uses mathc,arrays,baslib,arraysc;

function PixelX(x:complex):Integer;       overload;
function PixelY(x:complex):Integer;       overload;
function WindowX(x:complex):extended;      overload;
function WindowY(x:complex):extended;      overload;

procedure GraphPointsComplex(const a:array of complex);
procedure GraphLinesComplex(const a:array of complex);
procedure PlotPointsComplex(const a:array of complex);
procedure PlotLinesComplex(const a:array of complex);
procedure PlotLinesBeamOffComplex(const a:array of complex);
procedure GraphAreaComplex(const a: array of complex);
procedure PlotAreaComplex(const a:array of complex);

procedure GraphColorPointsComplex(const a:array of Complex; c:Complex);
procedure PlotColorPointsComplex(const a:array of Complex; c:Complex);

procedure PlotTextComplex(z:complex; const s:string);
procedure PlotTextUsingComplex(z:complex; const form:string; a:array of const; insideofwhen:boolean);
procedure GraphTextComplex(z:complex; const s:string);
procedure GraphTextUsingComplex(z:complex; const form:string; a:array of const; insideofwhen:boolean);
procedure PlotLabelComplex(z:complex; const s:string);
procedure PlotLabelUsingComplex(z:complex; const form:string; a:array of const; insideofwhen:boolean);
procedure GraphLabelComplex(z:complex; const s:string);
procedure GraphLabelUsingComplex(z:complex; const form:string; a:array of const; insideofwhen:boolean);
procedure PlotLettersComplex(z:complex; const s:string);
procedure PlotLettersUsingComplex(z:complex; const form:string; a:array of const; insideofwhen:boolean);


procedure MatPlotPoints(const x,y:TArray1C); overload;
procedure MatPlotPoints(const m:TArray2C);   overload;
procedure MatPlotLines(const x,y:TArray1C);  overload;
procedure MatPlotLines(const m:TArray2C);    overload;
procedure MatPlotArea(const x,y:TArray1C);   overload;
procedure MatPlotArea(const m:TArray2C);     overload;

procedure MatPlotPointsLimit(n:complex; const x,y:TArray1C);overload;
procedure MatPlotPointsLimit(n:complex; const m:TArray2C);  overload;
procedure MatPlotLinesLimit(n:complex; const x,y:TArray1C); overload;
procedure MatPlotLinesLimit(n:complex; const m:TArray2C);   overload;
procedure MatPlotAreaLimit(n:complex; const x,y:TArray1C);  overload;
procedure MatPlotAreaLimit(n:complex; const m:TArray2C);    overload;

procedure MatPlotLines(const z:TArray1C);    overload;
procedure MatPlotPoints(const z:TArray1C);   overload;
procedure MatPlotArea(const z:TArray1C);     overload;
procedure MatPlotPointsLimit(n:complex; const z:TArray1C);  overload;
procedure MatPlotLinesLimit(n:complex; const z:TArray1C);   overload;
procedure MatPlotAreaLimit(n:complex; const z:TArray1C);    overload;


procedure MatPlotCells(const p:TArray2C; const x1,y1,x2,y2:double; insideofWhen:boolean); overload;
procedure MatPlotCells(const p:TArray2C;  x1,y1,x2,y2:complex; insideofWhen:boolean);     overload;
procedure MatGraphCells(const p:TArray2C; const x1,y1,x2,y2:double; insideofWhen:boolean);overload;
procedure MatGraphCells(const p:TArray2C;  x1,y1,x2,y2:complex; insideofWhen:boolean);    overload;

{GET & LOCATE}
procedure PointAt(x0,y0:complex; LocateSt:boolean);                      overload;
procedure GetPoint(var x,y:complex; NoBeamOff:boolean; Locatest:boolean);overload;
procedure GetPoint(var x:double; var y:complex; NoBeamOff:boolean; Locatest:boolean);overload;
procedure GetPoint(var x:complex; var y:double; NoBeamOff:boolean; Locatest:boolean);overload;
procedure MousePoll(var x,y:double; var l:double; var r:complex);   overload;
procedure MousePoll(var x,y:double; var l:complex; var r:double);   overload;
procedure MousePoll(var x,y:double; var l,r:complex);               overload;
procedure MousePoll(var x:double; var y:complex; var l,r:double);   overload;
procedure MousePoll(var x:double; var y:complex; var l:double; var r:complex); overload;
procedure MousePoll(var x:double; var y:complex; var l:complex; var r:double); overload;
procedure MousePoll(var x:double; var y:complex; var l,r:complex ); overload;
procedure MousePoll(var x:complex; var y:double; var l,r:double);   overload;
procedure MousePoll(var x:complex; var y:double; var l:double; var r:complex); overload;
procedure MousePoll(var x:complex; var y:double; var l:complex; var r:double); overload;
procedure MousePoll(var x:complex; var y:double; var l,r:complex); overload;
procedure MousePoll(var x,y:complex; var l,r:double);              overload;
procedure MousePoll(var x,y:complex; var l:double; var r:complex); overload;
procedure MousePoll(var x,y:complex; var l:complex; var r:double); overload;
procedure MousePoll(var x,y,l,r:complex);                          overload;
procedure MatGetPointVarilen(m:TArray2C; Locatest:boolean);       overload;
procedure MatGetPointVarilen(m1,m2:TArray1C; Locatest:boolean);   overload;
procedure MatGetPoint(m1,m2:TArray1C; Locatest:boolean);          overload;
procedure MatGetPoint(m:TArray2C; Locatest:boolean);              overload;


Procedure LocateChoice( var x:complex);overload;
Procedure LocateChoice(n:complex; var x:complex);overload;
Procedure LocateChoice(n,i0:complex; var x:complex);overload;
Procedure LocateChoice(const a:TArray1S; var x:complex);overload;


{ASK Statements}
function ASkWindow(var x1:double; var x2:double; var y1:double; var y2:complex):integer; overload;
function ASkWindow(var x1:double; var x2:double; var y1:complex; var y2:double):integer; overload;
function ASkWindow(var x1:double; var x2:double; var y1:complex; var y2:complex):integer; overload;
function ASkWindow(var x1:double; var x2:complex; var y1:double; var y2:double):integer; overload;
function ASkWindow(var x1:double; var x2:complex; var y1:double; var y2:complex):integer; overload;
function ASkWindow(var x1:double; var x2:complex; var y1:complex; var y2:double):integer; overload;
function ASkWindow(var x1:double; var x2:complex; var y1:complex; var y2:complex):integer; overload;
function ASkWindow(var x1:complex; var x2:double; var y1:double; var y2:double):integer; overload;
function ASkWindow(var x1:complex; var x2:double; var y1:double; var y2:complex):integer; overload;
function ASkWindow(var x1:complex; var x2:double; var y1:complex; var y2:double):integer; overload;
function ASkWindow(var x1:complex; var x2:double; var y1:complex; var y2:complex):integer; overload;
function ASkWindow(var x1:complex; var x2:complex; var y1:double; var y2:double):integer; overload;
function ASkWindow(var x1:complex; var x2:complex; var y1:double; var y2:complex):integer; overload;
function ASkWindow(var x1:complex; var x2:complex; var y1:complex; var y2:double):integer; overload;
function ASkWindow(var x1:complex; var x2:complex; var y1:complex; var y2:complex):integer; overload;
function AskViewPort(var x1:double; var x2:double; var y1:double; var y2:complex):integer; overload;
function AskViewPort(var x1:double; var x2:double; var y1:complex; var y2:double):integer; overload;
function AskViewPort(var x1:double; var x2:double; var y1:complex; var y2:complex):integer; overload;
function AskViewPort(var x1:double; var x2:complex; var y1:double; var y2:double):integer; overload;
function AskViewPort(var x1:double; var x2:complex; var y1:double; var y2:complex):integer; overload;
function AskViewPort(var x1:double; var x2:complex; var y1:complex; var y2:double):integer; overload;
function AskViewPort(var x1:double; var x2:complex; var y1:complex; var y2:complex):integer; overload;
function AskViewPort(var x1:complex; var x2:double; var y1:double; var y2:double):integer; overload;
function AskViewPort(var x1:complex; var x2:double; var y1:double; var y2:complex):integer; overload;
function AskViewPort(var x1:complex; var x2:double; var y1:complex; var y2:double):integer; overload;
function AskViewPort(var x1:complex; var x2:double; var y1:complex; var y2:complex):integer; overload;
function AskViewPort(var x1:complex; var x2:complex; var y1:double; var y2:double):integer; overload;
function AskViewPort(var x1:complex; var x2:complex; var y1:double; var y2:complex):integer; overload;
function AskViewPort(var x1:complex; var x2:complex; var y1:complex; var y2:double):integer; overload;
function AskViewPort(var x1:complex; var x2:complex; var y1:complex; var y2:complex):integer; overload;
function AskDeviceWindow(var x1:double; var x2:double; var y1:double; var y2:complex):integer; overload;
function AskDeviceWindow(var x1:double; var x2:double; var y1:complex; var y2:double):integer; overload;
function AskDeviceWindow(var x1:double; var x2:double; var y1:complex; var y2:complex):integer; overload;
function AskDeviceWindow(var x1:double; var x2:complex; var y1:double; var y2:double):integer; overload;
function AskDeviceWindow(var x1:double; var x2:complex; var y1:double; var y2:complex):integer; overload;
function AskDeviceWindow(var x1:double; var x2:complex; var y1:complex; var y2:double):integer; overload;
function AskDeviceWindow(var x1:double; var x2:complex; var y1:complex; var y2:complex):integer; overload;
function AskDeviceWindow(var x1:complex; var x2:double; var y1:double; var y2:double):integer; overload;
function AskDeviceWindow(var x1:complex; var x2:double; var y1:double; var y2:complex):integer; overload;
function AskDeviceWindow(var x1:complex; var x2:double; var y1:complex; var y2:double):integer; overload;
function AskDeviceWindow(var x1:complex; var x2:double; var y1:complex; var y2:complex):integer; overload;
function AskDeviceWindow(var x1:complex; var x2:complex; var y1:double; var y2:double):integer; overload;
function AskDeviceWindow(var x1:complex; var x2:complex; var y1:double; var y2:complex):integer; overload;
function AskDeviceWindow(var x1:complex; var x2:complex; var y1:complex; var y2:double):integer; overload;
function AskDeviceWindow(var x1:complex; var x2:complex; var y1:complex; var y2:complex):integer; overload;
function AskDeviceViewPort(var x1:double; var x2:double; var y1:double; var y2:complex):integer; overload;
function AskDeviceViewPort(var x1:double; var x2:double; var y1:complex; var y2:double):integer; overload;
function AskDeviceViewPort(var x1:double; var x2:double; var y1:complex; var y2:complex):integer; overload;
function AskDeviceViewPort(var x1:double; var x2:complex; var y1:double; var y2:double):integer; overload;
function AskDeviceViewPort(var x1:double; var x2:complex; var y1:double; var y2:complex):integer; overload;
function AskDeviceViewPort(var x1:double; var x2:complex; var y1:complex; var y2:double):integer; overload;
function AskDeviceViewPort(var x1:double; var x2:complex; var y1:complex; var y2:complex):integer; overload;
function AskDeviceViewPort(var x1:complex; var x2:double; var y1:double; var y2:double):integer; overload;
function AskDeviceViewPort(var x1:complex; var x2:double; var y1:double; var y2:complex):integer; overload;
function AskDeviceViewPort(var x1:complex; var x2:double; var y1:complex; var y2:double):integer; overload;
function AskDeviceViewPort(var x1:complex; var x2:double; var y1:complex; var y2:complex):integer; overload;
function AskDeviceViewPort(var x1:complex; var x2:complex; var y1:double; var y2:double):integer; overload;
function AskDeviceViewPort(var x1:complex; var x2:complex; var y1:double; var y2:complex):integer; overload;
function AskDeviceViewPort(var x1:complex; var x2:complex; var y1:complex; var y2:double):integer; overload;
function AskDeviceViewPort(var x1:complex; var x2:complex; var y1:complex; var y2:complex):integer; overload;

function  AskPixelSize( var var1,var2:complex):integer;      overload;
function  AskPixelSize(n1,n2,n3,n4:complex; var var1,var2:complex):integer;overload;
function  AskPixelSize(n1,n2,n3,n4:complex; var var1:double; var var2:complex):integer;overload;
function  AskPixelSize(n1,n2,n3,n4:complex; var var1:complex; var var2:double):integer;overload;
function  AskPixelSize(n1,n2,n3,n4:complex; var var1,var2:int64):integer;overload;
function  AskPixelValue(x,y:complex; var var1:complex):integer;        overload;
function  AskPixelArray(x,y:complex; a:TArray2C):integer;              overload;
function  AskPixelArray(x,y:complex; a:TArray2C; s:TStrVar):integer;   overload;

function getlinecolor(var x:complex):integer;  overload;
function getlinestyle(var x:complex):integer;  overload;
function getlinewidth(var x:complex):integer;  overload;
function getpointcolor(var x:complex):integer;  overload;
function getpointstyle(var x:complex):integer;  overload;
function getareacolor(var x:complex):integer;  overload;
function gettextcolor(var x:complex):integer;   overload;
function getmaxcolor(var x:complex):integer;   overload;
function getaxiscolor(var x:complex):integer;   overload;
function getMaxPointDevice(var x:complex):integer;   overload;
function getMaxMultiPointDevice(var x:complex):integer;  overload;
function getMaxChoiceDevice(var x:complex):integer;   overload;
function getMaxValueDevice(var x:complex):integer;   overload;
function getAreaStyleIndex(var x:complex):integer;   overload;
function getmaxlinestyle(var x:complex):integer;      overload;
function getmaxpointstyle(var x:complex):integer;     overload;

function ASkTextHeight(var x:complex):integer;       overload;
function AskTextAngle(var x:complex):integer;         overload;
function AskTextAngleRad(var x:complex):integer;     overload;
function AskDeviceSize(var x,y:complex; t:TStrVar):integer;   overload;
function AskBitmapSize(var x,y:complex):integer;              overload;
function AskTextWidth(const s:string; var width:complex):integer;  overload;

//function AskColorMix(ColorIndex:complex; var red:double; var green:double; var blue:double):integer;  overload;
function AskColorMix(ColorIndex:complex; var red:double; var green:double; var blue:complex):integer;  overload;
function AskColorMix(ColorIndex:complex; var red:double; var green:complex; var blue:double):integer;  overload;
function AskColorMix(ColorIndex:complex; var red:double; var green:complex; var blue:complex):integer;  overload;
function AskColorMix(ColorIndex:complex; var red:complex; var green:double; var blue:double):integer;  overload;
function AskColorMix(ColorIndex:complex; var red:complex; var green:double; var blue:complex):integer;  overload;
function AskColorMix(ColorIndex:complex; var red:complex; var green:complex; var blue:double):integer;  overload;
function AskColorMix(ColorIndex:complex; var red, green, blue:complex):integer;  overload;

{Transfrom}
procedure mlt(a:TArray2C);  overload;
procedure shift(c:Complex); overload;
procedure cmlt(c:Complex);



implementation
uses graphsys, graphlib, affine, GraphQue;

function PixelX(x:complex):Integer;
begin
   result:=graphlib.PixelX(testreal(x))
end;

function PixelY(x:complex):Integer;
begin
   result:=graphlib.PixelY(testreal(x))
end;

function WindowX(x:complex):extended;
begin
   result:=graphlib.WindowX(testreal(x))
end;

function WindowY(x:complex):extended;
begin
   result:=graphlib.WindowY(testreal(x))
end;



function MakeDoubleArray(const a:array of complex):PDoubleArray;
var
  p:PDoubleArray;
  i:integer;
begin
  GetMem(p, sizeof(Double)*length(a)*2);
  for i:=low(a) to High(a) do
     begin
       p^[i*2]:=a[i].x;
       p^[i*2+1]:=a[i].y;
     end;
  result:=p;
end;


procedure GraphPointsComplex(const a:array of complex);
var
  p:PDoubleArray;
begin
  p:=MakeDoubleArray(a);
  graphlib.GraphPoints(Slice(p^, length(a)*2));
  freeMem(p, sizeof(Double)*length(a)*2)
end;

//var ColorPointsCriticalSection: TRTLCriticalSection;

procedure GraphColorPointsComplex(const a:array of complex; c:complex);
begin
   //EnterCriticalSection(ColorPointsCriticalSection);
    SetPointColor(c,false);
    GraphPointsComplex(a);
   //LeaveCriticalSection(ColorPointsCriticalSection);
end;

procedure PlotColorPointsComplex(const a:array of complex; c:complex);
begin
    //EnterCriticalSection(ColorPointsCriticalSection);
    SetPointColor(c,false);
    PlotPointsComplex(a);
    //LeaveCriticalSection(ColorPointsCriticalSection);
end;
procedure GraphLinesComplex(const a:array of complex);
var
  p:PDoubleArray;
begin
  p:=MakeDoubleArray(a);
  graphlib.GraphLines(Slice(p^, length(a)*2));
  freeMem(p, sizeof(Double)*length(a)*2)
end;

procedure PlotPointsComplex(const a:array of complex);
var
  p:PDoubleArray;
begin
  p:=MakeDoubleArray(a);
  graphlib.PlotPoints(Slice(p^, length(a)*2));
  freeMem(p, sizeof(Double)*length(a)*2)
end;


procedure PlotLinesComplex(const a:array of complex);
var
  p:PDoubleArray;
begin
  p:=MakeDoubleArray(a);
  graphlib.PlotLines(Slice(p^, length(a)*2));
  freeMem(p, sizeof(Double)*length(a)*2)
end;

procedure PlotLinesBeamOffComplex(const a:array of complex);
var
  p:PDoubleArray;
begin
  p:=MakeDoubleArray(a);
  graphlib.PlotLinesBeamoff(Slice(p^, length(a)*2));
  freeMem(p, sizeof(Double)*length(a)*2)
end;

procedure GraphAreaComplex(const a: array of complex);
var
  p:PDoubleArray;
begin
  p:=MakeDoubleArray(a);
  graphlib.GraphArea(Slice(p^, length(a)*2));
  freeMem(p, sizeof(Double)*length(a)*2)
end;

procedure PlotAreaComplex(const a:array of complex);
var
  p:PDoubleArray;
begin
  p:=MakeDoubleArray(a);
  graphlib.PlotArea(Slice(p^, length(a)*2));
  freeMem(p, sizeof(Double)*length(a)*2)
end;


procedure PlotText(x,y:complex; const s:string);
begin
   graphlib.PlotText(testreal(x), testreal(y), s);
end;

procedure PlotTextUsing(x,y:complex; const form:string; a:array of const; insideofwhen:boolean);
begin
   graphlib.PlotTextUsing(testreal(x), testreal(y), form, a, insideofwhen);
end;

procedure GraphText(x,y:complex; const s:string);
begin
   graphlib.GraphText(testreal(x), testreal(y), s);
end;

procedure GraphTextUsing(x,y:complex; const form:string; a:array of const; insideofwhen:boolean);
begin
   graphlib.GraphTextUsing(testreal(x), testreal(y), form, a, insideofwhen);
end;

procedure PlotLabel(x,y:complex; const s:string);
begin
   graphlib.PlotLabel(testreal(x), testreal(y), s);
end;

procedure PlotLabelUsing(x,y:complex; const form:string; a:array of const; insideofwhen:boolean);
begin
   graphlib.PlotLabelUsing(testreal(x), testreal(y), form, a, insideofwhen);
end;

procedure GraphLabel(x,y:complex; const s:string);
begin
   graphlib.GraphLabel(testreal(x), testreal(y), s);
end;

procedure GraphLabelUsing(x,y:complex; const form:string; a:array of const; insideofwhen:boolean);
begin
   graphlib.GraphLabelUsing(testreal(x), testreal(y), form, a, insideofwhen);
end;

procedure PlotLetters(x,y:complex; const s:string);
begin
   graphlib.PlotLetters(testreal(x), testreal(y), s);
end;

procedure PlotLettersUsing(x,y:complex; const form:string; a:array of const; insideofwhen:boolean);
begin
   graphlib.PlotLettersUsing(testreal(x), testreal(y), form, a, insideofwhen);
end;



procedure PlotTextComplex(z:complex; const s:string);
begin
  graphlib.PlotText(z.x, z.y, s)
end;

procedure PlotTextUsingComplex(z:complex; const form:string; a:array of const; insideofwhen:boolean);
begin
    graphlib.PlotTextUsing(z.x, z.y, form, a, insideofwhen)
end;

procedure GraphTextComplex(z:complex; const s:string);
begin
  graphlib.GraphText(z.x, z.y, s)
end;

procedure GraphTextUsingComplex(z:complex; const form:string; a:array of const; insideofwhen:boolean);
begin
  graphlib.GraphTextUsing(z.x, z.y, form, a, insideofwhen)
end;

procedure PlotLabelComplex(z:complex; const s:string);
begin
  graphlib.PlotLabel(z.x, z.y, s)
end;

procedure PlotLabelUsingComplex(z:complex; const form:string; a:array of const; insideofwhen:boolean);
begin
  graphlib.PlotLabelUsing(z.x, z.y, form, a, insideofwhen)
end;

procedure GraphLabelComplex(z:complex; const s:string);
begin
  graphlib.GraphLabel(z.x, z.y, s)
end;

procedure GraphLabelUsingComplex(z:complex; const form:string; a:array of const; insideofwhen:boolean);
begin
  GraphLabelUsing(z.x, z.y, form, a, insideofwhen)
end;

procedure PlotLettersComplex(z:complex; const s:string);
begin
  PlotLetters(z.x, z.y, s)
end;

procedure PlotLettersUsingComplex(z:complex; const form:string; a:array of const; insideofwhen:boolean);
begin
  PlotLettersUsing(z.x, z.y, form, a, insideofwhen)
end;



procedure MatPlotPoints(const x,y:TArray1C);overload;
var
  a,b:TArray1N;
begin
  a:=x.Array1N;
  b:=y.Array1N;
  try
     graphlib.MatPlotPoints(a,b);
  finally
    b.free;
    a.free;
  end;
end;

procedure MatPlotPoints(const z:TArray1C);
var
  a:TArray2N;
begin
  a:=z.Array2N;
  try
      graphlib.MatPlotPoints(a);
  finally
     a.free;
  end;
end;


procedure MatPlotPoints(const m:TArray2C);overload;
var
  a:TArray2N;
begin
  a:=m.Array2N;
  try
      graphlib.MatPlotPoints(a);
  finally
     a.free;
  end;
end;

procedure MatPlotLines(const x,y:TArray1C);overload;
var
  a,b:TArray1N;
begin
  a:=x.Array1N;
  b:=y.Array1N;
  try
    graphlib.MatPlotLines(a,b);
  finally
    b.free;
    a.free;
  end;
end;

procedure MatPlotLines(const m:TArray2C);overload;
var
  a:TArray2N;
begin
  a:=m.Array2N;
  try
     graphlib.MatPlotLines(a);
  finally
     a.free;
  end;
end;

procedure MatPlotLines(const z:TArray1C); overload;
var
   a:TArray2N;
begin
  a:=z.Array2N;
  try
     graphlib.MatPlotArea(a);
  finally
     a.free;
  end;
end;

procedure MatPlotArea(const x,y:TArray1C);overload;
var
  a,b:TArray1N;
begin
  a:=x.Array1N;
  b:=y.Array1N;
  try
     graphlib.MatPlotArea(a,b);
  finally
    b.free;
    a.free;
  end;
end;

procedure MatPlotArea(const z:TArray1C);
var
  a:TArray2N;
begin
  a:=z.Array2N;
  try
     graphlib.MatPlotArea(a);
  finally
     a.free;
  end;
end;


procedure MatPlotArea(const m:TArray2C);overload;
var
  a:TArray2N;
begin
  a:=m.Array2N;
  try
     graphlib.MatPlotArea(a);
  finally
     a.free;
  end;
end;

procedure MatPlotPointsLimit(n:complex; const x,y:TArray1C);overload;
var
  a,b:TArray1N;
begin
  a:=x.Array1N;
  b:=y.Array1N;
  try
     graphlib.MatPlotPointsLimit(testreal(n), a, b);
  finally
    b.free;
    a.free;
  end;
end;

procedure MatPlotPointsLimit(n:complex; const z:TArray1C); overload;
var
  a:TArray2N;
begin
  a:=z.Array2N;
  try
      graphlib.MatPlotPointsLimit(testreal(n), a);
  finally
     a.free;
  end;
end;


procedure MatPlotPointsLimit(n:complex; const m:TArray2C);overload;
var
  a:TArray2N;
begin
  a:=m.Array2N;
  try
      graphlib.MatPlotPointsLimit(testreal(n), a);
  finally
     a.free;
  end;
end;

procedure MatPlotLinesLimit(n:complex; const x,y:TArray1C);overload;
var
  a,b:TArray1N;
begin
  a:=x.Array1N;
  b:=y.Array1N;
  try
    graphlib.MatPlotLinesLimit(testreal(n), a, b);
  finally
    b.free;
    a.free;
  end;
end;

procedure MatPlotLinesLimit(n:complex; const m:TArray2C);overload;
var
  a:TArray2N;
begin
  a:=m.Array2N;
  try
     graphlib.MatPlotLinesLimit(testreal(n), a);
  finally
     a.free;
  end;
end;

procedure MatPlotLinesLimit(n:complex; const z:TArray1C);
var
  a:TArray2N;
begin
  a:=z.Array2N;
  try
     graphlib.MatPlotLinesLimit(testreal(n), a);
  finally
     a.free;
  end;
end;

procedure MatPlotAreaLimit(n:complex; const x,y:TArray1C);overload;
var
  a,b:TArray1N;
begin
  a:=x.Array1N;
  b:=y.Array1N;
  try
     graphlib.MatPlotAreaLimit(testreal(n),a,b);
  finally
    b.free;
    a.free;
  end;
end;

procedure MatPlotAreaLimit(n:complex; const z:TArray1C);
var
  a:TArray2N;
begin
  a:=z.Array2N;
  try
     graphlib.MatPlotAreaLimit(testreal(n),a);
  finally
     a.free;
  end;
end;


procedure MatPlotAreaLimit(n:complex; const m:TArray2C);overload;
var
  a:TArray2N;
begin
  a:=m.Array2N;
  try
     graphlib.MatPlotAreaLimit(testreal(n),a);
  finally
     a.free;
  end;
end;




{MAT PLOT CELLS}

procedure MatPlotCells(const p:TArray2C;  x1,y1,x2,y2:complex; insideofWhen:boolean);
var
   a:TArray2N;
begin
   a:=p.Array2N;
   try
      graphlib.MatPlotCells(a, testreal(x1), testreal(y1), testreal(x2), testreal(y2),insideofwhen);
   finally
      a.free;
   end;
end;

procedure MatPlotCells(const p:TArray2C; const x1, y1, x2, y2:double; insideofWhen:boolean);
var
   a:TArray2N;
begin
   a:=p.Array2N;
   try
      graphlib.MatPlotCells(a, testreal(x1), testreal(y1), testreal(x2), testreal(y2),insideofwhen);
   finally
      a.free;
   end;
end;

procedure MatGraphCells(const p:TArray2C; const x1, y1, x2, y2:double; insideofWhen:boolean);
var
   a:TArray2N;
begin
   a:=p.Array2N;
   try
      graphlib.MatPlotCells(a, testreal(x1), testreal(y1), testreal(x2), testreal(y2),insideofwhen);
   finally
      a.free;
   end;
end;


procedure MatGraphCells(const p:TArray2C; x1,y1,x2,y2:complex; insideofWhen:boolean);
var
   a:TArray2N;
begin
   a:=p.Array2N;
   try
      graphlib.MatGraphCells(a, testreal(x1), testreal(y1), testreal(x2), testreal(y2),insideofwhen);
   finally
      a.free;
   end;
end;



{GET & LOCATE}
procedure PointAt(x0,y0:complex; LocateSt:boolean);
begin
    graphlib.PointAt(testreal(x0), testreal(y0), LocateSt);
end;

procedure GetPoint(var x,y:complex; NoBeamOff:boolean; Locatest:boolean);
begin
   graphlib.GetPoint(x.x, y.x, NoBeamOff, LocateSt);
   x.y:=0;
   y.y:=0;
end;

procedure GetPoint(var x:double; var y:complex; NoBeamOff:boolean; Locatest:boolean);overload;
begin
   graphlib.GetPoint(x, y.x, NoBeamOff, LocateSt);
   y.y:=0;
end;

procedure GetPoint(var x:complex; var y:double; NoBeamOff:boolean; Locatest:boolean);overload;
begin
   graphlib.GetPoint(x.x, y, NoBeamOff, LocateSt);
   x.y:=0;
end;

procedure MousePoll(var x,y:double; var l:double; var r:complex);   overload;
begin
  Graphlib.MousePoll(x, y, l, r.x);
  r.y:=0;
end;
procedure MousePoll(var x,y:double; var l:complex; var r:double);   overload;
begin
  Graphlib.MousePoll(x, y, l.x, r);
  l.y:=0;;
end;

procedure MousePoll(var x,y:double; var l,r:complex);               overload;
begin
  Graphlib.MousePoll(x, y, l.x, r.x);
  l.y:=0; r.y:=0;
end;

procedure MousePoll(var x:double; var y:complex; var l,r:double);   overload;
begin
  Graphlib.MousePoll(x, y.x, l, r);
  y.y:=0;
end;

procedure MousePoll(var x:double; var y:complex; var l:double; var r:complex); overload;
begin
  Graphlib.MousePoll(x, y.x, l, r.x);
  y.y:=0;  r.y:=0
end;

procedure MousePoll(var x:double; var y:complex; var l:complex; var r:double); overload;
begin
  Graphlib.MousePoll(x, y.x, l.x, r);
  y.y:=0; l.y:=0;
end;

procedure MousePoll(var x:double; var y:complex; var l,r:complex ); overload;
begin
  Graphlib.MousePoll(x, y.x, l.x, r.x);
   y.y:=0; l.y:=0; r.y:=0;
end;

procedure MousePoll(var x:complex; var y:double; var l,r:double);   overload;
begin
  Graphlib.MousePoll(x.x, y, l, r);
  x.y:=0; y:=0; l:=0; r:=0;
end;

procedure MousePoll(var x:complex; var y:double; var l:double; var r:complex); overload;
begin
  Graphlib.MousePoll(x.x, y, l, r.x);
  x.y:=0;  r.y:=0;
end;

procedure MousePoll(var x:complex; var y:double; var l:complex; var r:double); overload;
begin
  Graphlib.MousePoll(x.x, y, l.x, r);
  x.y:=0;  l.y:=0;
end;

procedure MousePoll(var x:complex; var y:double; var l,r:complex); overload;
begin
  Graphlib.MousePoll(x.x, y, l.x, r.x);
  x.y:=0;  l.y:=0; r.y:=0;
end;

procedure MousePoll(var x,y:complex; var l,r:double);              overload;
begin
  Graphlib.MousePoll(x.x, y.x, l, r);
  x.y:=0; y.y:=0;
end;

procedure MousePoll(var x,y:complex; var l:double; var r:complex); overload;
begin
  Graphlib.MousePoll(x.x, y.x, l, r.x);
  x.y:=0; y.y:=0;  r.y:=0;
end;

procedure MousePoll(var x,y:complex; var l:complex; var r:double); overload;
begin
  Graphlib.MousePoll(x.x, y.x, l.x, r);
  x.y:=0; y.y:=0; l.y:=0;
end;

procedure MousePoll(var x,y,l,r:complex);                          overload;
begin
  Graphlib.MousePoll(x.x, y.x, l.x, r.x);
  x.y:=0; y.y:=0; l.y:=0; r.y:=0;
end;


procedure MatGetPointVarilen(m:TArray2C; Locatest:boolean); overload;
var
   a:TArray2N;
   i:integer;
begin
  with m do
      a:=TArray2N.create(Lbound(1), Ubound(1), Lbound(2), Ubound(2));
  try
     graphlib.MatGetPointVarilen(a, Locatest);
     m.size1:=a.size1;
     m.size2:=a.size2;
     with m do
       for i:=0 to size -1 do
          elements^[i]:=a.elements^[i];
  finally
     a.free;
  end;
end;

procedure MatGetPointVarilen(m1,m2:TArray1C; Locatest:boolean); overload;
var
   a1,a2:TArray1N;
   i:integer;
begin
  with m1 do
      a1:=TArray1N.create(Lbound, Ubound);
  with m2 do
      a2:=TArray1N.create(Lbound, Ubound);
  try
     graphlib.MatGetPointVarilen(a1,a2, Locatest);

     m1.size1:=a1.size1;
     with m1 do
       for i:=0 to size -1 do
          elements^[i]:=a1.elements^[i];

     m2.size1:=a2.size1;
     with m2 do
       for i:=0 to size -1 do
          elements^[i]:=a2.elements^[i];

  finally
     a2.free;
     a1.free;
  end;
end;

procedure MatGetPoint(m1,m2:TArray1C; Locatest:boolean); overload;
var
   a1,a2:TArray1N;
   i:integer;
begin
  with m1 do
      a1:=TArray1N.create(Lbound, Ubound);
  with m2 do
      a2:=TArray1N.create(Lbound, Ubound);
  try
     graphlib.MatGetPoint(a1,a2, Locatest);
     with m1 do
       for i:=0 to size -1 do
          elements^[i]:=a1.elements^[i];
     with m2 do
       for i:=0 to size -1 do
          elements^[i]:=a2.elements^[i];
  finally
     a2.free;
     a1.free;
  end;
end;

procedure MatGetPoint(m:TArray2C; Locatest:boolean);overload;
var
   a:TArray2N;
   i:integer;
begin
  with m do
      a:=TArray2N.create(Lbound(1), Ubound(1), Lbound(2), Ubound(2));
  try
     graphlib.MatGetPoint(a, Locatest);
     with m do
       for i:=0 to size -1 do
          elements^[i]:=a.elements^[i];
  finally
     a.free;
  end;
end;

Procedure LocateChoice( var x:complex);overload;
begin
   graphlib.LocateChoice(x.x);
   x.y:=0
end;

Procedure LocateChoice( n:complex; var x:complex);overload;
begin
   graphlib.LocateChoice(testreal(n), x.x);
   x.y:=0
end;

Procedure LocateChoice( n,i0:complex; var x:complex);overload;
begin
   graphlib.LocateChoice(testreal(n), testreal(i0), x.x);
   x.y:=0
end;

Procedure LocateChoice(const a:TArray1S; var x:complex);overload;
begin
   graphlib.LocateChoice(a, x.x);
   x.y:=0
end;



{ASK Statements}
function ASkWindow(var x1:double; var x2:double; var y1:double; var y2:complex):integer; overload;
begin
   result:=graphlib.ASkWindow(x1, x2, y1, y2.x);
   y2.y:=0;
end;

function ASkWindow(var x1:double; var x2:double; var y1:complex; var y2:double):integer; overload;
begin
   result:=graphlib.ASkWindow(x1, x2, y1.x, y2);
   y1.y:=0;
end;

function ASkWindow(var x1:double; var x2:double; var y1:complex; var y2:complex):integer; overload;
begin
   result:=graphlib.ASkWindow(x1, x2, y1.x, y2.x);
   y1.y:=0;
   y2.y:=0;
end;

function ASkWindow(var x1:double; var x2:complex; var y1:double; var y2:double):integer; overload;
begin
   result:=graphlib.ASkWindow(x1, x2.x, y1, y2);
   x2.y:=0;
end;

function ASkWindow(var x1:double; var x2:complex; var y1:double; var y2:complex):integer; overload;
begin
   result:=graphlib.ASkWindow(x1, x2.x, y1, y2.x);
   x2.y:=0;
   y2.y:=0;
end;

function ASkWindow(var x1:double; var x2:complex; var y1:complex; var y2:double):integer; overload;
begin
   result:=graphlib.ASkWindow(x1, x2.x, y1.x, y2);
   x2.y:=0;
   y1.y:=0;
end;

function ASkWindow(var x1:double; var x2:complex; var y1:complex; var y2:complex):integer; overload;
begin
   result:=graphlib.ASkWindow(x1, x2.x, y1.x, y2.x);
   x2.y:=0;
   y1.y:=0;
   y2.y:=0;
end;

function ASkWindow(var x1:complex; var x2:double; var y1:double; var y2:double):integer; overload;
begin
   result:=graphlib.ASkWindow(x1.x, x2, y1, y2);
   x1.y:=0;
end;

function ASkWindow(var x1:complex; var x2:double; var y1:double; var y2:complex):integer; overload;
begin
   result:=graphlib.ASkWindow(x1.x, x2, y1, y2.x);
   x1.y:=0;
   y2.y:=0;
end;

function ASkWindow(var x1:complex; var x2:double; var y1:complex; var y2:double):integer; overload;
begin
   result:=graphlib.ASkWindow(x1.x, x2, y1.x, y2);
   x1.y:=0;
   y1.y:=0;
end;

function ASkWindow(var x1:complex; var x2:double; var y1:complex; var y2:complex):integer; overload;
begin
   result:=graphlib.ASkWindow(x1.x, x2, y1.x, y2.x);
   x1.y:=0;
   y1.y:=0;
   y2.y:=0;
end;

function ASkWindow(var x1:complex; var x2:complex; var y1:double; var y2:double):integer; overload;
begin
   result:=graphlib.ASkWindow(x1.x, x2.x, y1, y2);
   x1.y:=0;
   x2.y:=0;
end;

function ASkWindow(var x1:complex; var x2:complex; var y1:double; var y2:complex):integer; overload;
begin
   result:=graphlib.ASkWindow(x1.x, x2.x, y1, y2.x);
   x1.y:=0;
   x2.y:=0;
   y2.y:=0;
end;

function ASkWindow(var x1:complex; var x2:complex; var y1:complex; var y2:double):integer; overload;
begin
   result:=graphlib.ASkWindow(x1.x, x2.x, y1.x, y2);
   x1.y:=0;
   x2.y:=0;
   y1.y:=0;
end;

function ASkWindow(var x1:complex; var x2:complex; var y1:complex; var y2:complex):integer; overload;
begin
   result:=graphlib.ASkWindow(x1.x, x2.x, y1.x, y2.x);
   x1.y:=0;
   x2.y:=0;
   y1.y:=0;
   y2.y:=0;
end;


function AskViewPort(var x1:double; var x2:double; var y1:double; var y2:complex):integer; overload;
begin
   result:=graphlib.AskViewPort(x1, x2, y1, y2.x);
   y2.y:=0;
end;

function AskViewPort(var x1:double; var x2:double; var y1:complex; var y2:double):integer; overload;
begin
   result:=graphlib.AskViewPort(x1, x2, y1.x, y2);
   y1.y:=0;
end;

function AskViewPort(var x1:double; var x2:double; var y1:complex; var y2:complex):integer; overload;
begin
   result:=graphlib.AskViewPort(x1, x2, y1.x, y2.x);
   y1.y:=0;
   y2.y:=0;
end;

function AskViewPort(var x1:double; var x2:complex; var y1:double; var y2:double):integer; overload;
begin
   result:=graphlib.AskViewPort(x1, x2.x, y1, y2);
   x2.y:=0;
end;

function AskViewPort(var x1:double; var x2:complex; var y1:double; var y2:complex):integer; overload;
begin
   result:=graphlib.AskViewPort(x1, x2.x, y1, y2.x);
   x2.y:=0;
   y2.y:=0;
end;

function AskViewPort(var x1:double; var x2:complex; var y1:complex; var y2:double):integer; overload;
begin
   result:=graphlib.AskViewPort(x1, x2.x, y1.x, y2);
   x2.y:=0;
   y1.y:=0;
end;

function AskViewPort(var x1:double; var x2:complex; var y1:complex; var y2:complex):integer; overload;
begin
   result:=graphlib.AskViewPort(x1, x2.x, y1.x, y2.x);
   x2.y:=0;
   y1.y:=0;
   y2.y:=0;
end;

function AskViewPort(var x1:complex; var x2:double; var y1:double; var y2:double):integer; overload;
begin
   result:=graphlib.AskViewPort(x1.x, x2, y1, y2);
   x1.y:=0;
end;

function AskViewPort(var x1:complex; var x2:double; var y1:double; var y2:complex):integer; overload;
begin
   result:=graphlib.AskViewPort(x1.x, x2, y1, y2.x);
   x1.y:=0;
   y2.y:=0;
end;

function AskViewPort(var x1:complex; var x2:double; var y1:complex; var y2:double):integer; overload;
begin
   result:=graphlib.AskViewPort(x1.x, x2, y1.x, y2);
   x1.y:=0;
   y1.y:=0;
end;

function AskViewPort(var x1:complex; var x2:double; var y1:complex; var y2:complex):integer; overload;
begin
   result:=graphlib.AskViewPort(x1.x, x2, y1.x, y2.x);
   x1.y:=0;
   y1.y:=0;
   y2.y:=0;
end;

function AskViewPort(var x1:complex; var x2:complex; var y1:double; var y2:double):integer; overload;
begin
   result:=graphlib.AskViewPort(x1.x, x2.x, y1, y2);
   x1.y:=0;
   x2.y:=0;
end;

function AskViewPort(var x1:complex; var x2:complex; var y1:double; var y2:complex):integer; overload;
begin
   result:=graphlib.AskViewPort(x1.x, x2.x, y1, y2.x);
   x1.y:=0;
   x2.y:=0;
   y2.y:=0;
end;

function AskViewPort(var x1:complex; var x2:complex; var y1:complex; var y2:double):integer; overload;
begin
   result:=graphlib.AskViewPort(x1.x, x2.x, y1.x, y2);
   x1.y:=0;
   x2.y:=0;
   y1.y:=0;
end;

function AskViewPort(var x1:complex; var x2:complex; var y1:complex; var y2:complex):integer; overload;
begin
   result:=graphlib.AskViewPort(x1.x, x2.x, y1.x, y2.x);
   x1.y:=0;
   x2.y:=0;
   y1.y:=0;
   y2.y:=0;
end;


function AskDeviceWindow(var x1:double; var x2:double; var y1:double; var y2:complex):integer; overload;
begin
   result:=graphlib.AskDeviceWindow(x1, x2, y1, y2.x);
   y2.y:=0;
end;

function AskDeviceWindow(var x1:double; var x2:double; var y1:complex; var y2:double):integer; overload;
begin
   result:=graphlib.AskDeviceWindow(x1, x2, y1.x, y2);
   y1.y:=0;
end;

function AskDeviceWindow(var x1:double; var x2:double; var y1:complex; var y2:complex):integer; overload;
begin
   result:=graphlib.AskDeviceWindow(x1, x2, y1.x, y2.x);
   y1.y:=0;
   y2.y:=0;
end;

function AskDeviceWindow(var x1:double; var x2:complex; var y1:double; var y2:double):integer; overload;
begin
   result:=graphlib.AskDeviceWindow(x1, x2.x, y1, y2);
   x2.y:=0;
end;

function AskDeviceWindow(var x1:double; var x2:complex; var y1:double; var y2:complex):integer; overload;
begin
   result:=graphlib.AskDeviceWindow(x1, x2.x, y1, y2.x);
   x2.y:=0;
   y2.y:=0;
end;

function AskDeviceWindow(var x1:double; var x2:complex; var y1:complex; var y2:double):integer; overload;
begin
   result:=graphlib.AskDeviceWindow(x1, x2.x, y1.x, y2);
   x2.y:=0;
   y1.y:=0;
end;

function AskDeviceWindow(var x1:double; var x2:complex; var y1:complex; var y2:complex):integer; overload;
begin
   result:=graphlib.AskDeviceWindow(x1, x2.x, y1.x, y2.x);
   x2.y:=0;
   y1.y:=0;
   y2.y:=0;
end;

function AskDeviceWindow(var x1:complex; var x2:double; var y1:double; var y2:double):integer; overload;
begin
   result:=graphlib.AskDeviceWindow(x1.x, x2, y1, y2);
   x1.y:=0;
end;

function AskDeviceWindow(var x1:complex; var x2:double; var y1:double; var y2:complex):integer; overload;
begin
   result:=graphlib.AskDeviceWindow(x1.x, x2, y1, y2.x);
   x1.y:=0;
   y2.y:=0;
end;

function AskDeviceWindow(var x1:complex; var x2:double; var y1:complex; var y2:double):integer; overload;
begin
   result:=graphlib.AskDeviceWindow(x1.x, x2, y1.x, y2);
   x1.y:=0;
   y1.y:=0;
end;

function AskDeviceWindow(var x1:complex; var x2:double; var y1:complex; var y2:complex):integer; overload;
begin
   result:=graphlib.AskDeviceWindow(x1.x, x2, y1.x, y2.x);
   x1.y:=0;
   y1.y:=0;
   y2.y:=0;
end;

function AskDeviceWindow(var x1:complex; var x2:complex; var y1:double; var y2:double):integer; overload;
begin
   result:=graphlib.AskDeviceWindow(x1.x, x2.x, y1, y2);
   x1.y:=0;
   x2.y:=0;
end;

function AskDeviceWindow(var x1:complex; var x2:complex; var y1:double; var y2:complex):integer; overload;
begin
   result:=graphlib.AskDeviceWindow(x1.x, x2.x, y1, y2.x);
   x1.y:=0;
   x2.y:=0;
   y2.y:=0;
end;

function AskDeviceWindow(var x1:complex; var x2:complex; var y1:complex; var y2:double):integer; overload;
begin
   result:=graphlib.AskDeviceWindow(x1.x, x2.x, y1.x, y2);
   x1.y:=0;
   x2.y:=0;
   y1.y:=0;
end;

function AskDeviceWindow(var x1:complex; var x2:complex; var y1:complex; var y2:complex):integer; overload;
begin
   result:=graphlib.AskDeviceWindow(x1.x, x2.x, y1.x, y2.x);
   x1.y:=0;
   x2.y:=0;
   y1.y:=0;
   y2.y:=0;
end;



function AskDeviceViewPort(var x1:double; var x2:double; var y1:double; var y2:complex):integer; overload;
begin
   result:=graphlib.AskDeviceViewPort(x1, x2, y1, y2.x);
   y2.y:=0;
end;

function AskDeviceViewPort(var x1:double; var x2:double; var y1:complex; var y2:double):integer; overload;
begin
   result:=graphlib.AskDeviceViewPort(x1, x2, y1.x, y2);
   y1.y:=0;
end;

function AskDeviceViewPort(var x1:double; var x2:double; var y1:complex; var y2:complex):integer; overload;
begin
   result:=graphlib.AskDeviceViewPort(x1, x2, y1.x, y2.x);
   y1.y:=0;
   y2.y:=0;
end;

function AskDeviceViewPort(var x1:double; var x2:complex; var y1:double; var y2:double):integer; overload;
begin
   result:=graphlib.AskDeviceViewPort(x1, x2.x, y1, y2);
   x2.y:=0;
end;

function AskDeviceViewPort(var x1:double; var x2:complex; var y1:double; var y2:complex):integer; overload;
begin
   result:=graphlib.AskDeviceViewPort(x1, x2.x, y1, y2.x);
   x2.y:=0;
   y2.y:=0;
end;

function AskDeviceViewPort(var x1:double; var x2:complex; var y1:complex; var y2:double):integer; overload;
begin
   result:=graphlib.AskDeviceViewPort(x1, x2.x, y1.x, y2);
   x2.y:=0;
   y1.y:=0;
end;

function AskDeviceViewPort(var x1:double; var x2:complex; var y1:complex; var y2:complex):integer; overload;
begin
   result:=graphlib.AskDeviceViewPort(x1, x2.x, y1.x, y2.x);
   x2.y:=0;
   y1.y:=0;
   y2.y:=0;
end;

function AskDeviceViewPort(var x1:complex; var x2:double; var y1:double; var y2:double):integer; overload;
begin
   result:=graphlib.AskDeviceViewPort(x1.x, x2, y1, y2);
   x1.y:=0;
end;

function AskDeviceViewPort(var x1:complex; var x2:double; var y1:double; var y2:complex):integer; overload;
begin
   result:=graphlib.AskDeviceViewPort(x1.x, x2, y1, y2.x);
   x1.y:=0;
   y2.y:=0;
end;

function AskDeviceViewPort(var x1:complex; var x2:double; var y1:complex; var y2:double):integer; overload;
begin
   result:=graphlib.AskDeviceViewPort(x1.x, x2, y1.x, y2);
   x1.y:=0;
   y1.y:=0;
end;

function AskDeviceViewPort(var x1:complex; var x2:double; var y1:complex; var y2:complex):integer; overload;
begin
   result:=graphlib.AskDeviceViewPort(x1.x, x2, y1.x, y2.x);
   x1.y:=0;
   y1.y:=0;
   y2.y:=0;
end;

function AskDeviceViewPort(var x1:complex; var x2:complex; var y1:double; var y2:double):integer; overload;
begin
   result:=graphlib.AskDeviceViewPort(x1.x, x2.x, y1, y2);
   x1.y:=0;
   x2.y:=0;
end;

function AskDeviceViewPort(var x1:complex; var x2:complex; var y1:double; var y2:complex):integer; overload;
begin
   result:=graphlib.AskDeviceViewPort(x1.x, x2.x, y1, y2.x);
   x1.y:=0;
   x2.y:=0;
   y2.y:=0;
end;

function AskDeviceViewPort(var x1:complex; var x2:complex; var y1:complex; var y2:double):integer; overload;
begin
   result:=graphlib.AskDeviceViewPort(x1.x, x2.x, y1.x, y2);
   x1.y:=0;
   x2.y:=0;
   y1.y:=0;
end;

function AskDeviceViewPort(var x1:complex; var x2:complex; var y1:complex; var y2:complex):integer; overload;
begin
   result:=graphlib.AskDeviceViewPort(x1.x, x2.x, y1.x, y2.x);
   x1.y:=0;
   x2.y:=0;
   y1.y:=0;
   y2.y:=0;
end;


function  AskPixelSize( var var1,var2:complex):integer;overload;
begin
   result:=graphlib.AskPixelSize(var1.x, var2.x);
   var1.y:=0;
   var2.y:=0
end;

function  AskPixelSize(n1,n2,n3,n4:complex; var var1,var2:double):integer;overload;
begin
   result:=graphlib.AskPixelSize(testreal(n1),testreal(n2),testreal(n3),testreal(n4),var1, var2);
end;

function  AskPixelSize(n1,n2,n3,n4:complex; var var1:double; var var2:complex):integer;overload;
begin
   result:=graphlib.AskPixelSize(testreal(n1),testreal(n2),testreal(n3),testreal(n4),var1, var2.x);
   var2.y:=0
end;

function  AskPixelSize(n1,n2,n3,n4:complex; var var1:complex; var var2:double):integer;overload;
begin
   result:=graphlib.AskPixelSize(testreal(n1),testreal(n2),testreal(n3),testreal(n4),var1.x, var2);
   var1.y:=0;
end;

function  AskPixelSize(n1,n2,n3,n4:complex; var var1,var2:complex):integer;overload;
begin
   result:=graphlib.AskPixelSize(testreal(n1),testreal(n2),testreal(n3),testreal(n4),var1.x, var2.x);
   var1.y:=0;
   var2.y:=0
end;

function  AskPixelSize(n1,n2,n3,n4:complex; var var1,var2:int64):integer;overload;
begin
   result:=graphlib.AskPixelSize(testreal(n1),testreal(n2),testreal(n3),testreal(n4),var1, var2);
end;


function  AskPixelValue(x,y:complex; var var1:complex):integer;
begin
   result:=graphlib.AskPixelValue(testreal(x),testreal(y),var1.x);
   var1.y:=0;
end;


function  AskPixelArray(x,y:complex; a:TArray2C):integer; overload;
var
   n:TArray2N;
   i:integer;
begin
  with a do
      n:=TArray2N.create(Lbound(1), Ubound(1), Lbound(2), Ubound(2));
  try
     result:=graphlib.AskPixelArray(testreal(x), testreal(y), n);
     with a do
       for i:=0 to size -1 do
          elements^[i]:=n.elements^[i];
  finally
     n.free;
  end;
end;

function  AskPixelArray(x,y:complex; a:TArray2C; s:TStrVar):integer; overload;
var
   n:TArray2N;
   i:integer;
begin
  with a do
      n:=TArray2N.create(Lbound(1), Ubound(1), Lbound(2), Ubound(2));
  try
     result:=graphlib.AskPixelArray(testreal(x), testreal(y), n, s);
     with a do
       for i:=0 to size -1 do
          elements^[i]:=n.elements^[i];
  finally
     n.free;
  end;
end;


function getlinecolor(var x:complex):integer;
begin
  result:=graphlib.GetLineColor(x.x);
  x.y:=0;
end;

function getlinestyle(var x:complex):integer;
begin
  result:=graphlib.GetLineStyle(x.x);
  x.y:=0;
end;

function getlinewidth(var x:complex):integer;
begin
  result:=graphlib.GetLineWidth(x.x);
  x.y:=0;
end;

function getpointcolor(var x:complex):integer;
begin
  result:=graphlib.GetPointColor(x.x);
  x.y:=0;
end;

function getpointstyle(var x:complex):integer;
begin
  result:=graphlib.GetPointStyle(x.x);
  x.y:=0;
end;

function getareacolor(var x:complex):integer;
begin
  result:=graphlib.GetAreaColor(x.x);
  x.y:=0;
end;

function gettextcolor(var x:complex):integer;
begin
  result:=graphlib.GetTextColor(x.x);
  x.y:=0;
end;

function getmaxcolor(var x:complex):integer;
begin
  result:=graphlib.GetMaxColor(x.x);
  x.y:=0;
end;

function getaxiscolor(var x:complex):integer;
begin
  result:=graphlib.GetAxisColor(x.x);
  x.y:=0;
end;

function getMaxPointDevice(var x:complex):integer;
begin
  result:=graphlib.GetMaxPointDevice(x.x);
  x.y:=0;
end;

function getMaxMultiPointDevice(var x:complex):integer;
begin
  result:=graphlib.GetMaxMultiPointDevice(x.x);
  x.y:=0;
end;
function getMaxChoiceDevice(var x:complex):integer;
begin
  result:=graphlib.GetMaxChoiceDevice(x.x);
  x.y:=0;
end;
function getMaxValueDevice(var x:complex):integer;
begin
  result:=graphlib.GetMaxValueDevice(x.x);
  x.y:=0;
end;

function getAreaStyleIndex(var x:complex):integer;
begin
  result:=graphlib.GetAreaStyleIndex(x.x);
  x.y:=0;
end;

function getmaxlinestyle(var x:complex):integer;
begin
  result:=graphlib.getmaxlinestyle(x.x);
  x.y:=0;
end;

function getmaxpointstyle(var x:complex):integer;
begin
  result:=graphlib.getmaxpointstyle(x.x);
  x.y:=0;
end;


function ASkTextHeight(var x:complex):integer;
begin
  result:=graphlib.ASkTextHeight(x.x);
  x.y:=0;
end;

function AskTextAngle(var x:complex):integer;
begin
  result:=graphlib.ASkTextAngle(x.x);
  x.y:=0;
end;

function AskTextAngleRad(var x:complex):integer;
begin
  result:=graphlib.ASkTextAngleRad(x.x);
  x.y:=0;
end;

function AskDeviceSize(var x,y:complex; t:TStrVar):integer;
begin
   result:=graphlib.AskDeviceSize(x.x, y.x, t);
   x.y:=0; y.y:=0
end;

function AskBitmapSize(var x,y:complex):integer;
begin
   result:=graphlib.AskBitmapSize(x.x, y.x);
   x.y:=0; y.y:=0
end;

function AskTextWidth(const s:string; var width:complex):integer;
begin
  result:=graphlib.AskTextWidth(s, width.x);
  width.y:=0
end;

function AskColorMix(ColorIndex:complex; var red,green,blue:complex):integer;
begin
   result:=graphlib.AskColorMix(testreal(ColorIndex), red.x, green.y, blue.x);
   red.y:=0; green.y:=0; blue.y:=0;
end;

function AskColorMix(ColorIndex:complex; var red:double; var green:double; var blue:double):integer;  overload;
begin
   result:=graphlib.AskColorMix(testreal(ColorIndex), red, green, blue);
end;

function AskColorMix(ColorIndex:complex; var red:double; var green:double; var blue:complex):integer;  overload;
begin
   result:=graphlib.AskColorMix(testreal(ColorIndex), red, green, blue.x);
   blue.y:=0;
end;

function AskColorMix(ColorIndex:complex; var red:double; var green:complex; var blue:double):integer;  overload;
begin
   result:=graphlib.AskColorMix(testreal(ColorIndex), red, green.y, blue);
   green.y:=0;
end;

function AskColorMix(ColorIndex:complex; var red:double; var green:complex; var blue:complex):integer;  overload;
begin
   result:=graphlib.AskColorMix(testreal(ColorIndex), red, green.y, blue.x);
   green.y:=0; blue.y:=0;
end;

function AskColorMix(ColorIndex:complex; var red:complex; var green:double; var blue:double):integer;  overload;
begin
   result:=graphlib.AskColorMix(testreal(ColorIndex), red.x, green, blue);
   red.y:=0;
end;

function AskColorMix(ColorIndex:complex; var red:complex; var green:double; var blue:complex):integer;  overload;
begin
   result:=graphlib.AskColorMix(testreal(ColorIndex), red.x, green, blue.x);
   red.y:=0;  blue.y:=0;
end;

function AskColorMix(ColorIndex:complex; var red:complex; var green:complex; var blue:double):integer;  overload;
begin
   result:=graphlib.AskColorMix(testreal(ColorIndex), red.x, green.y, blue);
   red.y:=0; green.y:=0;
end;

{Transfrom}

procedure shift(c:Complex);
begin
  currenttransform.shift(c);
end;


procedure cmlt(c:Complex);
begin
   currenttransform.cmlt(c);
end;



procedure mlt(a:TArray2C);
begin
  currenttransform.mlt(a);
end;



end.

