unit inputdlg;

{$IFDEF FPC}
  {$MODE DELPHI}{$H+}
{$ENDIF}

(***************************************)
(* Copyright (C) 2003, SHIRAISHI Kazuo *)
(***************************************)


interface

uses  Types, Classes, Graphics, Forms, Controls, Buttons, StdCtrls, LResources,
     SysUtils, Dialogs;

type

  { TInputDialog }

  TInputDialog = class(TForm)
    Edit1: TEdit;
    OKBtn: TBitBtn;
    Label1: TLabel;
    Label2: TLabel;
    help1: TBitBtn;
    CancelBtn: TBitBtn;

    procedure FormCloseQuery(Sender: TObject; var CanClose: boolean);
    procedure FormDestroy(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure OKBtnClick(Sender: TObject);
    procedure CancelBtnClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);

  private
     height0:integer;
  public
     frag:boolean;
     LineNumber:integer;
     TimeLimit:TDateTime;
     procedure execute;
   end;

var
  InputDialog: TInputDialog;

implementation
uses
     base,base2;
  {$R *.lfm}


  procedure TInputDialog.FormCreate(Sender: TObject);
  begin
    with TMyIniFile.create('InputDlg') do
      begin
         left:=ReadInteger('left',left);
         top:=ReadInteger('top',top);
         free
      end;
  end;

  procedure TInputDialog.FormDestroy(Sender: TObject);
  begin
      with TMyIniFile.create('InputDlg') do
        begin
            WriteInteger('Left',ScaleFormTo96(Left));
            WriteInteger('Top',ScaleFormTo96(Top));
            Free
        end;

  end;

procedure TInputDialog.execute;
begin
   //Edit1.Font.Assign(EditorFont);
   frag:=false;
   show;
   //setfocus;
   repeat
       sleep(10);
       Application.ProcessMessages;
   until frag or (now>=timelimit);
   hide;  //close;

end;


procedure TInputDialog.FormResize(Sender: TObject);
begin
   if Height0=0 then
      Height0:=Height
   else
      Height:=Height0;
   Edit1.Left:=7;
   Edit1.width:=width-22;
   with Help1 do Left:=Self.width-12-width;
   with CancelBtn do Left:=Help1.Left-width-4;
   with OkBtn do Left:=CancelBtn.Left-width-4;
end;


procedure TInputDialog.FormActivate(Sender: TObject);
begin
    Edit1.SetFocus
end;

procedure TInputDialog.OKBtnClick(Sender: TObject);
begin
    frag:=true;
end;

procedure TInputDialog.CancelBtnClick(Sender: TObject);
begin
      frag:=true;
      ctrlBreakHit:=true;
end;

procedure TInputDialog.FormCloseQuery(Sender: TObject; var CanClose: boolean);
begin
   if Frag=false then
      ModalResult:=mrCancel;
end;




initialization



end.
