unit compadlg;

{$IFDEF FPC}
  {$MODE DELPHI}{$H+}
{$ENDIF}

(***************************************)
(* Copyright (C) 2003, SHIRAISHI Kazuo *)
(***************************************)


interface

uses  SysUtils, Classes, Graphics, Forms, Controls, StdCtrls,
  Buttons, ExtCtrls, ComCtrls, LResources;

type

  { TcompatibilityDialog }

  TcompatibilityDialog = class(TForm)
    CheckGroup1: TCheckGroup;
    OKBtn: TButton;
    CancelBtn: TButton;
    HelpBtn: TButton;
    PageControl1: TPageControl;
    RadioGroup12: TRadioGroup;
    RadioGroup3: TRadioGroup;
    RadioGroup13: TRadioGroup;
    RadioGroup14: TRadioGroup;
    RadioGroup7: TRadioGroup;
    RadioGroup8: TRadioGroup;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    TabSheet3: TTabSheet;
    RadioGroup1: TRadioGroup;
    RadioGroup4: TRadioGroup;
    RadioGroup5: TRadioGroup;
    RadioGroup2: TRadioGroup;
    RadioGroup6: TRadioGroup;
    RadioGroup9: TRadioGroup;
    RadioGroup11: TRadioGroup;
    TabSheet4: TTabSheet;
    procedure HelpBtnClick(Sender: TObject);
  private
    { Private 宣言 }
  public
    { Public 宣言 }
  end;

var
  compatibilityDialog: TcompatibilityDialog;

procedure setCompatibility;

implementation

uses base, base0, texthand, express, htmlhelp, graphic, confopt;
{$R *.lfm}


procedure TcompatibilityDialog.HelpBtnClick(Sender: TObject);
begin
  OpenHelp(HelpContext);
end;

procedure setCompatibility;

begin
   with compatibilityDialog do
   begin
       RadioGroup1.ItemIndex:=byte(JISFormat);
       RadioGroup2.ItemIndex:=byte(InitialCharacterByte0);
       RadioGroup3.ItemIndex:=byte(InitialBeamMode);
       RadioGroup4.ItemIndex:=byte(JISDim);
       RadioGroup5.ItemIndex:=byte(ForceFunctionDeclare);
       RadioGroup6.ItemIndex:=byte(JISDef);
       RadioGroup7.ItemIndex:=byte(initialUseEXTYPE);
       RadioGroup8.ItemIndex:=byte(DefaultOptionArith);           //ver.1.2.2.2
       RadioGroup9.ItemIndex:=byte(ForNextBroadOwn);
       RadioGroup11.ItemIndex:=1-byte(TextPhysicalCoordinate);
       //RadioGroup12.ItemIndex:=byte(ResultVarStatic);
       RadioGroup13.ItemIndex:=byte(DisableAbbreviatedPLOT);
       RadioGroup14.ItemIndex:=byte(ForceSubPictDeclare);
       CheckGroup1.Checked[0]:=GreekIdf;
       CheckGroup1.Checked[1]:=KanjiIdf;
      if ShowModal=mrOK then
        begin
          byte(JISFormat):=RadioGroup1.ItemIndex;
          byte(InitialCharacterByte0):=RadioGroup2.ItemIndex;
          byte(InitialBeamMode):=RadioGroup3.ItemIndex;
          byte(JISDim):=RadioGroup4.ItemIndex;
          byte(ForceFunctionDeclare):=RadioGroup5.ItemIndex;
          byte(JISDef):=RadioGroup6.ItemIndex;
          byte(initialUseEXTYPE):=RadioGroup7.ItemIndex;
          byte(DefaultOptionArith):=RadioGroup8.ItemIndex;         //ver.1.2.2.2
          byte(ForNextBroadown):=RadioGroup9.ItemIndex;
          byte(TextPhysicalCoordinate):=1-byte(RadioGroup11.ItemIndex) ;
          //TextProblemCoordinate:=RadioGroup11.ItemIndex = 2;
          //byte(ResultVarStatic):=RadioGroup12.ItemIndex;
          byte(DisableAbbreviatedPLOT):=RadioGroup13.ItemIndex;
          byte(ForceSubPictDeclare):=RadioGroup14.ItemIndex;
          GreekIdf := CheckGroup1.Checked[0];
          KanjiIdf := CheckGroup1.Checked[1];
          initIdentifierChar;
         end;
   end;
end;

initialization

  with TMyIniFile.create('Frame') do
   begin
     JISFormat:=            ReadBool('JISFormat',JISFormat);
     InitialCharacterByte0:=ReadBool('CharacterByte', InitialCharacterByte0);
     //JISSetWindow:=         ReadBool('JISSetWindow',JISSetWindow);          ver.1.2.2
     JISDim:=               ReadBool('JISDim',JISDim);
     ForceFunctionDeclare:= ReadBool('ForceFunctionDeclare',ForceFunctionDeclare);
     ForceSubPictDeclare:=  ReadBool('ForceSubPictDeclare', ForceSubPictDeclare);
     JISDef:=               ReadBool('JISDef',JISDef);
     ForNextBroadOwn:=      ReadBool('ForNextBroadOwn',ForNextBroadOwn);
     //ResultVarStatic:=      ReadBool('ResultVarStatic',ResultVarStatic);
     GreekIdf:=             ReadBool('GreekIdf',GreekIdf);
     KanjiIdf:=             ReadBool('KanjiIdf',GreekIdf);
     {$IFDEF Windows}
     InitialUseEXTYPE:=     ReadBool('initialUseEXTYPE',initialUseEXTYPE);
     {$ENDIF}
     free
   end;
 with TMyIniFile.create('Graphics') do
  begin
     //GeometricPenOnly:=     ReadBool('GeometricPenOnly',GeometricPenOnly);
     //ForwardPlot:=          ReadBool('ForwardPlot',ForwardPlot);
     TextPhysicalCoordinate:=  not ReadBool('TextProblemCoordinate',false);     //ver.7.8.7
     DisableAbbreviatedPLOT:=  ReadBool('DisableAbbreviatedPLOT',DisableAbbreviatedPLOT);
     InitialBeamMode:= ReadBool('InitialBeamMode',InitialBeamMode);
     free
  end;

finalization
  with TMyIniFile.create('Frame') do
   begin
    WriteBool('JISFormat',JISFormat);
    WriteBool('CharacterByte', InitialCharacterByte0);
    //WriteBool('JISSetWindow',JISSetWindow);                        ver.1.2.2
    WriteBool('JISDim',JISDim);
    WriteBool('ForceFunctionDeclare',ForceFunctionDeclare);
    WriteBool('ForceSubPictDeclare', ForceSubPictDeclare);
    WriteBool('JISDef',JISDef);
    WriteBool('ForNextBroadOwn',ForNextBroadOwn);
    //WriteBool('ResultVarStatic',ResultvarStatic);
    WriteBool('GreekIdf',GreekIdf);
    WriteBool('KanjiIdf',KanjiIdf);
    {$IFDEF Windows}
    WriteBool('initialUseEXTYPE',initialUseEXTYPE);
    {$ENDIF}
    free
   end;
 with TMyIniFile.create('Graphics') do
  begin
      //WriteBool('GeometricPenOnly',GeometricPenOnly);
      //WriteBool('ForwardPlot',ForwardPlot);
      WriteBool('InitialBeamMode',InitialBeamMode);
      WriteBool('TextProblemCoordinate', not TextPhysicalCoordinate);           //ver.7.8.7
      WriteBool('DisableAbbreviatedPLOT',DisableAbbreviatedPLOT);
   free
  end;



end.

