unit intlib;

{$IFDEF FPC}
  {$MODE DELPHI}{$H+}
{$ENDIF}
{$INLINE ON}
(***************************************)
(* Copyright (C) 2018, SHIRAISHI Kazuo *)
(***************************************)


interface
uses
  Classes, SysUtils, Forms,Dialogs,Controls,math,Process,FileUtil,LCLProc,
  lclintf, Clipbrd, UTF8Process,
  base,base2,baslib;

function BMOD( x,y:int64):int64;     overload;
function remainder(x,y:int64):int64; overload;
function CSqr(x:int64):int64;        overload;
function SGN(x:double):integer;    //overload;
   // Optimize Integer on 時，SGNの値はinteger。

implementation

(*
{$IFDEF CPUx64}
{$IFDEF Windows}
function remainder(x,y:int64):int64;assembler;
    //           rcx,rdx
asm
    mov rax,rcx
    mov rbx,rdx
    cqo
    idiv rbx
    mov rax,rdx
end;
{$ELSE}
 function remainder(x,y:int64):int64;assembler;
     //           rdi,rsi
asm
    mov rax,rdi
    cqo
    idiv rsi
    mov rax,rdx
end;
{$ENDIF}
{$ELSE}
{$ENDIF}
*)

function remainder(x,y:int64):int64; inline;
 begin
   result:=x mod y
 end;

function BMOD(x,y:int64):int64;
begin
  if y>0 then
     begin
        result:=x mod y;
        if result<0 then
           result:=(x mod y)+y
     end
  else if y<0 then
     begin
        result:=x mod y;
        if result>0 then
           result:=(x mod y)+y
     end
  else
       setexception(3006)
end;

function CSqr(x:int64):int64; inline;
begin
  result:=sqr(x)
end;

function SGN(x:double):integer; inline;
begin
    result:=sign(x)
end;

end.

