library BitArray;

uses
  Windows,
  HeapMem in 'HEAPMEM.PAS';

function MemSize(s:integer):integer;
begin
   result:=(s shr 5) shl 2;
   if (s and 31) <>0 then inc(result,4)
end;

const
  HEAP_ZERO_MEMORY = $00000008;
function GetArray(s:integer):pointer;stdcall;
begin
   Result:=HeapAlloc(HHeap,HEAP_ZERO_MEMORY,MemSize(s));
end;

procedure FreeArray(p:pointer); stdcall;
begin
  HeapFree(HHeap,0,p)
end;

function Test(p:pointer; i:integer):integer;stdcall;
begin
  asm
   mov eax,i
   mov edx,p
   bt  [edx],eax
   mov eax,0
   rcl eax,1
   mov result,eax
  end;
end;

procedure SetBit(p:pointer; i:integer);stdcall;
begin
  asm
   mov eax,i
   mov edx,p
   bts [edx],eax
  end;
end;

procedure ResetBit(p:pointer; i:integer);stdcall;
begin
  asm
   mov eax,i
   mov edx,p
   btr [edx],eax
  end;
end;

exports GetArray,FreeArray,Test,SetBit,ResetBit ;

end.
