unit SetPath;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil,  LResources, Forms, Controls, Graphics, Dialogs,
  EditBtn, StdCtrls, Buttons, ExtCtrls,LCLIntf, LCLType;

type

  { TPathDialog }

  TPathDialog = class(TForm)
    CancelButton: TButton;
    DirectoryEdit2: TDirectoryEdit;
    DirectoryEdit1: TDirectoryEdit;
    GroupBox1: TGroupBox;
    Label2: TLabel;
    Label1: TLabel;
    OkButton1: TButton;
    OpenDialog1: TOpenDialog;
    TargetCPU: TRadioGroup;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure TargetCPUClick(Sender: TObject);
  private
    { private declarations }
  public
    procedure execute;
  end; 

var
  PathDialog: TPathDialog;
  Path1,Path2,Path3,Path4:TFileName;


implementation
uses
  base,base0;
{$R *.lfm}

 { TPathDialog }

 {$IFDEF Linux}
 function getDefaultpath:string;
 var
   rec1,rec2:TSearchRec;
 const
   s0='/usr/lib64/lazarus';
   s1='/usr/lib/lazarus';
   s2='/usr/share/lazarus';
 begin
   result:='';
   if DirectoryExists(s2+'/lcl') then
          result:=s2
   else
   if DirectoryExists(s0+'/lcl') then
         result:=s0
   else
   if DirectoryExists(s1+'/lcl') then
         result:=s1
   else
   if DirectoryExists(s1+'/default/lcl') then
         result:=s1+'/default'
   else
   if (findfirst(s2+'/4.*',FaDirectory,rec2)=0)
   or (findfirst(s2+'/3.*',FaDirectory,rec2)=0)
   or (findfirst(s2+'/2.*',FaDirectory,rec2)=0)  then
      begin
          result:=s2+'/'+rec2.name;
          findclose(rec2);
      end
   else
   if (findfirst(s1+'/4.*',FaDirectory,rec1)=0)
   or (findfirst(s1+'/3.*',FaDirectory,rec1)=0)
   or (findfirst(s1+'/2.*',FaDirectory,rec1)=0)
   or (findfirst(s1+'/1.*',FaDirectory,rec1)=0) then
      begin
        result:=s1+'/'+rec1.name;
        findclose(rec1);
      end
   else
     ShowMessage('Failed to set Lazarus Path');

 end;
 {$ENDIF}

procedure TPathDialog.FormCreate(Sender: TObject);
var
   p:integer;
begin
    with TMyIniFile.create('Path') do
    begin
      TargetCPU64:=(ReadBool('TargetCPU', TargetCPU64));
     {$IFDEF Windows}
      Path1:=ReadString('Path1','C:\Lazarus\fpc\3.2.2\bin\i386-win32');
      Path2:=ReadString('Path2','C:\Lazarus');
      Path3:=ReadString('Path3','C:\Lazarus\fpc\3.2.2\bin\x86_64-win64');
      Path4:=ReadString('Path4','C:\Lazarus');
     {$ENDIF}
     {$IFDEF Linux}
      Path1:=ReadString('Path1','/usr/bin');
      Path2:=ReadString('Path2', '');
      Path3:=ReadString('Path3','/usr/bin');
      Path4:=ReadString('Path4', '');
      {$IFDEF CPU32}
       if path2='' then Path2:=getDefaultpath;
      {$ENDIF}
      {$IFDEF CPU64}
       if path4='' then Path4:=getDefaultpath;
      {$ENDIF}
     {$ENDIF}
     {$IFDEF Darwin}
      Path1:=ReadString('Path1','/usr/local/bin');
      Path2:=ReadString('Path2','/Applications/Lazarus');
      Path3:=ReadString('Path3','/usr/local/bin');
      Path4:=ReadString('Path4','/Applications/Lazarus');
    {$ENDIF}
      free
    end;

    TargetCPU.ItemIndex:=byte(TargetCPU64);

    // ver. 0.9.1に上書きの場合の処理
   p:=Pos('\lcl\units\',Path2);
   if p>0 then
      Path2:=Copy(Path2,1,p-1);
end;


procedure TPathDialog.FormDestroy(Sender: TObject);
begin
  with TMyIniFile.create('Path') do
      begin
          WriteBool('TargetCPU',TargetCPU64);
          WriteString('Path1',Path1);
          WriteString('Path2',Path2);
          WriteString('Path3',Path3);
          WriteString('Path4',Path4);
         Free
      end;
end;

procedure TPathDialog.TargetCPUClick(Sender: TObject);
begin
   case TargetCPU.ItemIndex of
     0: {32 bit}
      begin
       DirectoryEdit1.Directory:=Path1;
       DirectoryEdit2.Directory:=Path2;
      end;
     1: {64 bit}
      begin
       DirectoryEdit1.Directory:=Path3;
       DirectoryEdit2.Directory:=Path4;
      end;
   end;
end;

procedure TPathDialog.execute;
begin
   TargetCPU.ItemIndex:=byte(TargetCPU64);
   TargetCPUClick(Self);

   if showModal=mrOk then
      begin
       case TargetCPU.ItemIndex of
         0: {32 bit}
          begin
           Path1 := DirectoryEdit1.Directory;
           Path2 := DirectoryEdit2.Directory;
          end;
         1: {64 bit}
          begin
           Path3 := DirectoryEdit1.Directory;
           Path4 := DirectoryEdit2.Directory;
          end;
        end;
       byte(TargetCPU64):=TargetCPU.Itemindex;
      end;
end;

initialization



finalization


end.

